<?php
namespace app\controllers;
use Yii;
use yii\web\Controller;
use yii\data\ActiveDataProvider;
use app\models\Application;
use app\models\User;

class AdminController extends Controller
{
    public function beforeAction($action)
    {
        if (Yii::$app->user->isGuest || !Yii::$app->user->identity->isAdmin()) {
            Yii::$app->session->setFlash('error', 'Доступ запрещен');
            return $this->redirect(['site/login']);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex()
    {
        $query = Application::find()
            ->with('user')
            ->orderBy(['created_at' => SORT_DESC]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        // Получаем статистику отдельными запросами
        $totalApplications = Application::find()->count();
        $newApplications = Application::find()->where(['status' => 'new'])->count();
        $learningApplications = Application::find()->where(['status' => 'learning'])->count();
        $completedApplications = Application::find()->where(['status' => 'completed'])->count();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'totalApplications' => $totalApplications,
            'newApplications' => $newApplications,
            'learningApplications' => $learningApplications,
            'completedApplications' => $completedApplications,
        ]);
    }

    public function actionUpdateStatus($id, $status)
    {
        $application = Application::findOne($id);
        if ($application) {
            $application->status = $status;
            $application->save();
            Yii::$app->session->setFlash('success', 'Статус заявки обновлен');
        }

        return $this->redirect(['index']);
    }
}