<?php
namespace app\controllers;
use Yii;
use yii\web\Controller;
use yii\data\ActiveDataProvider;
use app\models\Application;
use app\models\Review;

class ApplicationController extends Controller
{
    public function actionIndex()
    {
        $query = Application::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->orderBy(['created_at' => SORT_DESC]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionCreate()
    {
        $model = new Application();
        $model->user_id = Yii::$app->user->id;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Заявка создана!');
            return $this->redirect(['index']);
        }

        return $this->render('create', ['model' => $model]);
    }

    public function actionReview($id)
    {
        $application = Application::findOne(['id' => $id, 'user_id' => Yii::$app->user->id]);

        if (!$application || $application->status !== 'completed') {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена или обучение еще не завершено.');
        }

        $model = new Review();
        $model->user_id = Yii::$app->user->id;
        $model->application_id = $id;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Отзыв добавлен!');
            return $this->redirect(['index']);
        }

        return $this->render('review', [
            'model' => $model,
            'application' => $application
        ]);
    }
}