<?php
namespace app\controllers;
use app\models\LoginForm;
use Yii;
use yii\web\Controller;
use app\models\User;

class SiteController extends Controller
{
    public function actionIndex()
    {
        if (!Yii::$app->user->isGuest) {
            $user = Yii::$app->user->identity;
            if ($user->isAdmin()) {
                return $this->redirect(['admin/index']);
            } else {
                return $this->redirect(['application/index']);
            }
        }

        return $this->render('index');
    }


    public function actionRegister()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new User();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Регистрация успешна! Теперь вы можете войти.');
            return $this->redirect(['login']);
        }

        return $this->render('register', ['model' => $model]);
    }


    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();

        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            $user = Yii::$app->user->identity;
            if ($user->role === 'admin') {
                return $this->redirect(['admin/index']);
            }
            return $this->redirect(['application/index']);
        }

        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
}