<?php
use yii\db\Migration;

class mXXXXXX_XXXXXX_init extends Migration
{
    public function safeUp()
    {
        // Таблица пользователей
        $this->createTable('users', [
            'id' => $this->primaryKey(),
            'login' => $this->string(50)->notNull()->unique(),
            'password' => $this->string(255)->notNull(),
            'full_name' => $this->string(100)->notNull(),
            'phone' => $this->string(20)->notNull(),
            'email' => $this->string(100)->notNull(),
            'role' => $this->string(10)->notNull()->defaultValue('user'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        // Таблица заявок
        $this->createTable('applications', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'course_name' => $this->string(200)->notNull(),
            'desired_start_date' => $this->date()->notNull(),
            'payment_method' => $this->string(20)->notNull(),
            'status' => $this->string(20)->notNull()->defaultValue('new'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey('fk_app_user', 'applications', 'user_id', 'users', 'id', 'CASCADE');

        // Таблица отзывов
        $this->createTable('reviews', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'application_id' => $this->integer()->notNull(),
            'review_text' => $this->text()->notNull(),
            'rating' => $this->integer()->notNull(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey('fk_rev_user', 'reviews', 'user_id', 'users', 'id', 'CASCADE');
        $this->addForeignKey('fk_rev_app', 'reviews', 'application_id', 'applications', 'id', 'CASCADE');
    }

    public function safeDown()
    {
        $this->dropTable('reviews');
        $this->dropTable('applications');
        $this->dropTable('users');
    }
}