<?php
namespace app\models;
use yii\db\ActiveRecord;

class Application extends ActiveRecord
{
    public static function tableName()
    {
        return 'applications';
    }

    public function rules()
    {
        return [
            [['course_name', 'desired_start_date', 'payment_method'], 'required'],
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    public function getReview()
    {
        return $this->hasOne(Review::className(), ['application_id' => 'id']);
    }

    public function attributeLabels()
    {
        return [
            'course_name' => 'Наименование курса',
            'desired_start_date' => 'Желаемая дата начала обучения',
            'payment_method' => 'Способ оплаты',
        ];
    }
}