<?php
use yii\helpers\Html;

$statusClasses = [
    'new' => 'secondary',
    'learning' => 'warning',
    'completed' => 'success'
];

$statusLabels = [
    'new' => 'Новая',
    'learning' => 'Идет обучение',
    'completed' => 'Завершено'
];

$paymentLabels = [
    'cash' => 'Наличными',
    'phone' => 'Перевод по телефону'
];
?>

<div class="card mb-3">
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <h6 class="card-title"><?= Html::encode($model->course_name) ?></h6>
                <p class="card-text mb-1">
                    <strong>Студент:</strong>
                    <?= $model->user ? Html::encode($model->user->full_name) : 'Неизвестно' ?>
                </p>
                <p class="card-text mb-1">
                    <strong>Контакты:</strong>
                    <?= $model->user ? $model->user->phone : '-' ?>,
                    <?= $model->user ? $model->user->email : '-' ?>
                </p>
                <p class="card-text mb-1">
                    <strong>Дата начала:</strong> <?= Yii::$app->formatter->asDate($model->desired_start_date) ?>
                </p>
                <p class="card-text mb-0">
                    <strong>Оплата:</strong> <?= $paymentLabels[$model->payment_method] ?? $model->payment_method ?>
                </p>
            </div>
            <div class="col-md-3 text-center">
                <span class="badge badge-<?= $statusClasses[$model->status] ?> badge-pill p-2" style="font-size: 1em;">
                    <?= $statusLabels[$model->status] ?? $model->status ?>
                </span>
                <p class="text-muted mt-2 mb-0">
                    <small>Создано: <?= Yii::$app->formatter->asDatetime($model->created_at) ?></small>
                </p>
            </div>
            <div class="col-md-3 text-right">
                <?php if ($model->status === 'new'): ?>
                    <?= Html::a('Начать обучение', ['update-status', 'id' => $model->id, 'status' => 'learning'], [
                        'class' => 'btn btn-warning btn-sm mb-1'
                    ]) ?>
                <?php elseif ($model->status === 'learning'): ?>
                    <?= Html::a('Завершить', ['update-status', 'id' => $model->id, 'status' => 'completed'], [
                        'class' => 'btn btn-success btn-sm mb-1'
                    ]) ?>
                <?php endif; ?>

                <?php if ($model->status === 'completed' && $model->review): ?>
                    <span class="badge badge-info">Есть отзыв</span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>