<?php
use yii\helpers\Html;
use yii\widgets\ListView;
?>

<div class="admin-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <!-- Статистика -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h4><?= $totalApplications ?></h4>
                    <p>Всего заявок</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h4><?= $newApplications ?></h4>
                    <p>Новые заявки</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h4><?= $learningApplications ?></h4>
                    <p>В процессе обучения</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h4><?= $completedApplications ?></h4>
                    <p>Завершено</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Список заявок -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Заявки на обучение</h5>
        </div>
        <div class="card-body">
            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'itemView' => '_admin_application_item',
                'layout' => "{items}\n{pager}",
                'emptyText' => 'Заявок нет.',
                'emptyTextOptions' => ['class' => 'alert alert-info'],
            ]); ?>
        </div>
    </div>
</div>