<?php
use yii\helpers\Html;
use yii\helpers\Url;

// Карта статусов
$statusClasses = [
    'new' => 'secondary',
    'learning' => 'warning',
    'completed' => 'success'
];

$statusLabels = [
    'new' => 'Новая',
    'learning' => 'Идет обучение',
    'completed' => 'Завершено'
];

$paymentLabels = [
    'cash' => 'Наличными',
    'phone' => 'Перевод по телефону'
];
?>

<div class="card mb-3">
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
                <h5 class="card-title"><?= Html::encode($model->course_name) ?></h5>
                <p class="card-text">
                    <strong>Дата начала:</strong> <?= Yii::$app->formatter->asDate($model->desired_start_date) ?><br>
                    <strong>Способ оплаты:</strong> <?= $paymentLabels[$model->payment_method] ?? $model->payment_method ?>
                </p>
                <p class="card-text">
                    <small class="text-muted">
                        Создано: <?= Yii::$app->formatter->asDatetime($model->created_at) ?>
                    </small>
                </p>
            </div>
            <div class="col-md-4 text-right">
                <span class="badge badge-<?= $statusClasses[$model->status] ?> badge-pill p-2 mb-2">
                    <?= $statusLabels[$model->status] ?? $model->status ?>
                </span>
                <br>
                <?php if ($model->status === 'completed' && !$model->review): ?>
                    <?= Html::a('Оставить отзыв', ['review', 'id' => $model->id], [
                        'class' => 'btn btn-primary btn-sm mt-2'
                    ]) ?>
                <?php elseif ($model->review): ?>
                    <span class="badge badge-info mt-2">Отзыв оставлен</span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>