<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Создание заявки';
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="application-create">
    <div class="row">
        <div class="col-md-8">
            <h1><?= Html::encode($this->title) ?></h1>

            <?php if (Yii::$app->session->hasFlash('success')): ?>
                <div class="alert alert-success">
                    <?= Yii::$app->session->getFlash('success') ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <?php $form = ActiveForm::begin(); ?>

                    <?= $form->field($model, 'course_name')->textInput([
                        'maxlength' => true,
                        'placeholder' => 'Например: Web-разработка, Digital-маркетинг...'
                    ])->label('Название курса') ?>

                    <?= $form->field($model, 'desired_start_date')->input('date', [
                        'min' => date('Y-m-d')
                    ])->label('Желаемая дата начала') ?>

                    <?= $form->field($model, 'payment_method')->radioList([
                        'cash' => '💵 Наличными',
                        'phone' => '📱 Перевод по номеру телефона'
                    ], [
                        'class' => 'btn-group',
                        'data-toggle' => 'buttons',
                        'unselect' => null,
                        'item' => function($index, $label, $name, $checked, $value) {
                            return '<label class="btn btn-outline-primary ' . ($checked ? 'active' : '') . '">' .
                                Html::radio($name, $checked, ['value' => $value, 'autocomplete' => 'off']) .
                                $label . '</label>';
                        }
                    ])->label('Способ оплаты') ?>

                    <div class="form-group">
                        <?= Html::submitButton('📨 Отправить заявку', [
                            'class' => 'btn btn-success btn-lg btn-block'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Популярные курсы</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li>🎯 Web-разработка</li>
                        <li>📊 Digital-маркетинг</li>
                        <li>🎨 Графический дизайн</li>
                        <li>📈 Анализ данных</li>
                        <li>🤖 Python-программирование</li>
                        <li>📱 Мобильная разработка</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5>Как это работает?</h5>
                </div>
                <div class="card-body">
                    <ol class="pl-3">
                        <li>Выбираете курс</li>
                        <li>Отправляете заявку</li>
                        <li>Ждете подтверждения</li>
                        <li>Начинаете обучение</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>