<?php
use yii\helpers\Html;
use yii\widgets\ListView;
?>

<div class="application-index">
    <div class="row">
        <div class="col-md-8">
            <h1><?= Html::encode($this->title) ?></h1>
        </div>
        <div class="col-md-4 text-right">
            <?= Html::a('<i class="fas fa-plus"></i> Создать заявку', ['create'], ['class' => 'btn btn-success']) ?>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'itemView' => '_application_item',
                'layout' => "{items}\n{pager}",
                'emptyText' => 'У вас пока нет заявок.',
                'emptyTextOptions' => ['class' => 'alert alert-info'],
            ]); ?>
        </div>
    </div>
</div>