<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Оставить отзыв';
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="review-create">
    <div class="row">
        <div class="col-md-8">
            <h1><?= Html::encode($this->title) ?></h1>

            <!-- Информация о курсе -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Информация о курсе</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <strong>Курс:</strong><br>
                            <?= Html::encode($application->course_name) ?>
                        </div>
                        <div class="col-md-6">
                            <strong>Дата начала:</strong><br>
                            <?= Yii::$app->formatter->asDate($application->desired_start_date) ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Форма отзыва -->
            <div class="card">
                <div class="card-body">
                    <?php $form = ActiveForm::begin(); ?>

                    <div class="form-group">
                        <label>Ваша оценка</label>
                        <div class="rating-stars">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <div class="form-check form-check-inline">
                                    <?= Html::radio('Review[rating]', $model->rating == $i, [
                                        'value' => $i,
                                        'id' => 'rating' . $i,
                                        'class' => 'form-check-input'
                                    ]) ?>
                                    <label class="form-check-label" for="rating<?= $i ?>">
                                        <?= str_repeat('⭐', $i) ?>
                                    </label>
                                </div>
                            <?php endfor; ?>
                        </div>
                        <?php if ($model->hasErrors('rating')): ?>
                            <div class="text-danger"><?= $model->getFirstError('rating') ?></div>
                        <?php endif; ?>
                    </div>

                    <?= $form->field($model, 'review_text')->textarea([
                        'rows' => 6,
                        'placeholder' => 'Расскажите о вашем опыте обучения... Что понравилось? Что можно улучшить?'
                    ])->label('Текст отзыва') ?>

                    <div class="form-group">
                        <?= Html::submitButton('📝 Отправить отзыв', [
                            'class' => 'btn btn-success btn-lg'
                        ]) ?>
                        <?= Html::a('Отмена', ['index'], [
                            'class' => 'btn btn-secondary btn-lg'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Советы по отзыву</h5>
                </div>
                <div class="card-body">
                    <ul>
                        <li>Опишите ваш опыт обучения</li>
                        <li>Что было особенно полезно?</li>
                        <li>Какие есть предложения по улучшению?</li>
                        <li>Порекомендуете ли курс другим?</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .rating-stars {
        font-size: 1.5em;
    }
    .form-check-input:checked + .form-check-label {
        font-weight: bold;
    }
</style>