<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="site-index">
    <div class="jumbotron" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 0;">
        <div class="container text-center">
            <h1 class="display-4">Корочки.есть</h1>
            <p class="lead">Портал дополнительного профессионального образования</p>
            <p>Получите качественное образование и официальные документы</p>
            <div class="mt-4">
                <?= Html::a('Начать обучение', ['site/register'], ['class' => 'btn btn-success btn-lg mr-3']) ?>
                <?= Html::a('Уже есть аккаунт', ['site/login'], ['class' => 'btn btn-outline-light btn-lg']) ?>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <div class="row text-center">
            <div class="col-md-4 mb-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <i class="fas fa-graduation-cap fa-3x text-primary mb-3"></i>
                        <h4>Профессиональные курсы</h4>
                        <p class="text-muted">Более 50 программ повышения квалификации и переподготовки</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <i class="fas fa-certificate fa-3x text-warning mb-3"></i>
                        <h4>Официальные документы</h4>
                        <p class="text-muted">Дипломы и удостоверения государственного образца</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <i class="fas fa-laptop fa-3x text-success mb-3"></i>
                        <h4>Онлайн-формат</h4>
                        <p class="text-muted">Учитесь из любой точки мира в удобное время</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Популярные курсы</h2>
            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Web-разработка</h5>
                            <p class="card-text">Современные технологии веб-разработки: HTML, CSS, JavaScript, PHP</p>
                            <span class="badge badge-primary">6 месяцев</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Digital-маркетинг</h5>
                            <p class="card-text">Продвижение в интернете: SEO, SMM, контекстная реклама</p>
                            <span class="badge badge-primary">4 месяца</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Графический дизайн</h5>
                            <p class="card-text">Adobe Photoshop, Illustrator, Figma и основы композиции</p>
                            <span class="badge badge-primary">5 месяцев</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Анализ данных</h5>
                            <p class="card-text">Python, SQL, Excel и визуализация данных</p>
                            <span class="badge badge-primary">7 месяцев</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5 text-center">
        <h3>Готовы начать обучение?</h3>
        <p class="lead mb-4">Присоединяйтесь к тысячам студентов, которые уже получили новые профессии</p>
        <?= Html::a('Зарегистрироваться', ['site/register'], ['class' => 'btn btn-primary btn-lg']) ?>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">